<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Provider\ProfileController;
use App\Http\Controllers\Api\Provider\ProductController;


Route::prefix('provider')
    ->namespace('App\Http\Controllers\Api\Provider')
    ->group(function () {

        Route::post('register', 'ProviderAuthController@register');
        Route::post('login', 'ProviderAuthController@login');
        Route::post('password/forgot', 'ProviderAuthController@forgotPassword');
        Route::post('password/reset', 'ProviderAuthController@resetPassword');
        Route::get("/reset-password", function () {
            return "password-reset";
        })->name("password.reset");

        Route::middleware(['auth:sanctum', 'provider', 'provider.inactive'])
            ->group(function () {

                // Profile Management
                Route::get('profile', [ProfileController::class, 'show']);
                Route::post('profile', [ProfileController::class, 'update']);
                Route::put('bank-details', [ProfileController::class, 'updateBankDetails']);
                Route::put('password/change', [ProfileController::class, 'changePassword']);
                Route::post('password/send-verification-code', 'ProviderAuthController@sendVerificationCode');
                Route::post('profile/change-contact-details', 'ProviderAuthController@changeContactDetails');
                Route::delete('profile', [ProfileController::class, 'destroy']);


                // Service & Package Management
                Route::apiResource('products', ProductController::class)->except('update');
                Route::post('products/{product}', [ProductController::class, 'update']);
                Route::post('products/{product}/toggle-status', [ProductController::class, 'toggleStatus']);


                // Notifications
                Route::get('notifications', 'NotificationController@index');
                Route::post('notifications/mark-all-as-read', 'NotificationController@markAllAsRead');
                Route::post('notifications/{id}/mark-as-read', 'NotificationController@markAsRead');

                Route::get('bookings', 'BookingController@index');
                Route::get('bookings/{id}', 'BookingController@show')->name('provider.booking-items.show');
                Route::post('bookings/{id}/confirm', 'BookingController@confirm');
                Route::post('bookings/{id}/complete', 'BookingController@complete');
                Route::post('bookings/{id}/decline', 'BookingController@decline');


                Route::get('dashboard', 'DashboardController@dashboard');
            });
    });
