<?php

namespace Database\Seeders;

use App\Models\Category;
use App\Models\City;
use App\Models\Product;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ServiceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = Category::all();
        if ($categories->isEmpty()) {
            $categories = Category::factory()->count(10)->create();
        }

        $products = Product::factory()->count(15)->create([
            'type' => 'service',
            'category_id' => $categories->random()->id
        ]);

        foreach ($products as $product) {
            $product->addMediaFromUrl('https://picsum.photos/200/300')->toMediaCollection('images');
            $product->addMediaFromUrl('https://picsum.photos/200/300')->toMediaCollection('images');
            $product->addMediaFromUrl('https://picsum.photos/200/300')->toMediaCollection('images');
            $product->addMediaFromUrl('https://static.videezy.com/system/resources/previews/000/000/417/original/100_0126.mp4')->toMediaCollection('videos');
            $product->availabilities()->createMany([
                ['date' => now()->addDays(1)],
                ['date' => now()->addDays(2)],
                ['date' => now()->addDays(3)],
            ]);
            $product->cities()->attach(City::query()->inRandomOrder()->limit(1)->pluck('id'));
        }
    }
}
