<?php

namespace Database\Seeders;

use App\Models\City;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CitySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $cities = [
            ['name_en' => 'Riyadh', 'name_ar' => 'الرياض'],
            ['name_en' => 'Jeddah', 'name_ar' => 'جدة'],
            ['name_en' => 'Dammam', 'name_ar' => 'الدمام'],
            ['name_en' => 'Mecca', 'name_ar' => 'مكة المكرمة'],
            ['name_en' => 'Medina', 'name_ar' => 'المدينة المنورة'],
        ];

        foreach ($cities as $city) {
            City::create($city);
        }
    }
}
