<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('service_providers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('category_id')->nullable()->constrained("categories")->onDelete('SET NULL');
            $table->string('name');
            $table->string('email')->unique();
            $table->string('phone')->unique();
            $table->string('password');
            $table->foreignId('nationality_id')->constrained('nationalities');
            $table->string('id_number')->nullable();
            $table->string('commercial_register_type')->nullable();
            $table->string('commercial_register_number')->nullable();
            $table->string('iban')->nullable();
            $table->string('bank_name')->nullable();
            $table->decimal('commission_rate', 5, 2)->nullable();
            $table->string('badge_url')->nullable();
            $table->boolean('is_active')->default(false);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('service_providers');
    }
};
