<?php

namespace Database\Factories;

use App\Models\Category;
use App\Models\ServiceProvider;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Product>
 */
class ProductFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name_en' => $this->faker->word,
            'name_ar' => $this->faker->word,
            'description_en' => $this->faker->sentence,
            'description_ar' => $this->faker->sentence,
            'details_en' => $this->faker->paragraph,
            'details_ar' => $this->faker->paragraph,
            'price' => $this->faker->randomFloat(2, 10, 100),
            // Randomly null or a float greater than price
            'price_before_discount' => $this->faker->boolean ? null : $this->faker->randomFloat(2, 100, 200),
            'service_provider_id' => ServiceProvider::factory(),
            'category_id' => Category::factory(),
            'type' => $this->faker->randomElement(['service', 'package']),
            'is_active' => $this->faker->boolean,
            "location_url" => 'https://maps.app.goo.gl/Qg6c7ZhtMY5DwEDPA',
        ];
    }
}
