<?php

namespace App\Policies;

use App\Models\Admin;
use App\Models\Booking;
use App\Models\ServiceProvider;
use Illuminate\Auth\Access\HandlesAuthorization;

class BookingPolicy
{
    use HandlesAuthorization;

    public function view(ServiceProvider|Admin $provider, Booking $booking)
    {
        return class_basename(auth('admin')->user()) === 'Admin' || $provider->id === $booking->service_provider_id;
    }

    public function update(ServiceProvider|Admin $provider, Booking $booking)
    {
        return class_basename(auth('admin')->user()) === 'Admin' || $provider->id === $booking->service_provider_id;
    }
}
