<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;

class ServiceProviderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data = [
            'id' => $this->id,
            'name' => $this->name,

            'category_id' => $this->category_id,
            'category' => $this->whenLoaded('category'),
            'nationality_id' => $this->nationality_id,
            'nationality' => $this->whenLoaded('nationality'),
            'cities' => $this->whenLoaded('cities'),
            'is_active' => $this->is_active,
            'logo' => $this->logo ? Storage::url($this->logo) : Storage::url('logos/default.png'),
            'badge_url' => $this->badge_url ? Storage::url($this->badge_url) : null,
            'email' => $this->email,
            'phone' => $this->phone,
        ];
        if ($this->id == auth()->id() && class_basename(auth()->user()) === 'ServiceProvider') {
            $data = array_merge($data, [

                "has_commercial_register" => !$this->id_number ? true : false,
                'id_number' => $this->id_number,
                'commercial_register_type' => $this->commercial_register_type,
                'commercial_register_number' => $this->commercial_register_number,
                'commission_rate' => $this->commission_rate,
                'bank_name' => $this->bank_name,
                'iban' => $this->iban,
            ]);
        }
        return $data;
    }
}
