<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PackageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $locale = app()->getLocale();
        if ($this->resource->trashed()) {
            $this->resource->is_active = false;
        }

        if (request()->is('api/user/*')) {
            $data = [
                'name' => $this->{'name_' . $locale},
                'description' => $this->{'description_' . $locale},
                'details' => $this->{'details_' . $locale},

            ];
        } else {
            $data = [
                'name_ar' => $this->name_ar,
                'name_en' => $this->name_en,
                'details_ar' => $this->{'details_ar'},
                'details_en' => $this->{'details_en'},

            ];
        };
        return array_merge($data, [
            'id' => $this->id,
            'type' => $this->type,
            'price' => $this->price,
            'price_before_discount' => $this->price_before_discount,
            'location_url' => $this->location_url,
            'is_active' => $this->is_active,
            'avg_rating' => $this->avg_rating,
            'cities' => CityResource::collection($this->whenLoaded('cities')),
            'availabilities' => $this->whenLoaded('availabilities'),
            // when media is loaded return images key and videos key
            'images' => $this->whenLoaded(
                'media',
                MediaResource::collection($this->media->where('collection_name', 'images'))
            ),
            // 'videos' => $this->whenLoaded(
            //     'media',
            //     MediaResource::collection($this->media->where('collection_name', 'videos'))
            // ),
            'booked_dates' => $this->whenLoaded('bookedItems', $this->booked_dates),
            'service_provider' => new ServiceProviderResource($this->whenLoaded('serviceProvider')),
        ]);
    }
}
