<?php

namespace App\Http\Requests\Api\Provider;

use Illuminate\Foundation\Http\FormRequest;

class ChangeContactDetailsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'code' => 'required|string',
            'email' => 'nullable|email|unique:service_providers,email',
            'phone' => 'nullable|numeric|unique:service_providers,phone|starts_with:9665|digits:12',
        ];
    }
    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            if (!$this->input('email') && !$this->input('phone')) {
                $validator->errors()->add('field', __('messages.one_of_email_or_phone_is_required'));
            }
            if ($this->input('email') && $this->input('phone')) {
                $validator->errors()->add('field', __('messages.one_of_email_or_phone_is_required'));
            }
        });
    }
}
