<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class CheckProviderStatus
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (Auth::guard()->check() && !Auth::guard()->user()->is_active) {
            $user = Auth::guard()->user();
            if ($user) {
                $user->tokens()->delete();
            }
            return response()->json(['message' => __('messages.inactive_account')], 403);
        }

        return $next($request);
    }
}
