<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\NationalityResource;
use App\Models\Nationality;
use Illuminate\Http\Request;

class NationalityController extends Controller
{
    /**
     * @OA\Get(
     *      path="/api/nationalities",
     *      operationId="getNationalitiesList",
     *      tags={"Public"},
     *      summary="Get list of nationalities",
     *      description="Returns list of nationalities",
     *      @OA\Parameter(
     *         name="Accept-Language",
     *         in="header",
     *         required=false,
     *         description="Language preference (e.g., 'en', 'ar')",
     *         @OA\Schema(type="string", enum={"en", "ar"}, default="en")
     *      ),
     *      @OA\Response(
     *          response=200,
     *          description="Successful operation",
     *          @OA\JsonContent(ref="#/components/schemas/NationalityResource")
     *       ),
     *     )
     */
    public function index()
    {
        return NationalityResource::collection(Nationality::query()->scopes(['active'])->get());
    }
}
