<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\CityResource;
use App\Models\City;
use Illuminate\Http\Request;

class CityController extends Controller
{
    /**
     * @OA\Get(
     *      path="/api/cities",
     *      operationId="getCitiesList",
     *      tags={"Public"},
     *      summary="Get list of cities",
     *      description="Returns list of cities",
     *      @OA\Parameter(
     *         name="Accept-Language",
     *         in="header",
     *         required=false,
     *         description="Language preference (e.g., 'en', 'ar')",
     *         @OA\Schema(type="string", enum={"en", "ar"}, default="en")
     *      ),
     *      @OA\Response(
     *          response=200,
     *          description="Successful operation",
     *          @OA\JsonContent(ref="#/components/schemas/CityResource")
     *       ),
     *     )
     */
    public function index()
    {
        return CityResource::collection(City::query()->scopes(['active'])->get());
    }
}
