<?php

namespace App\Filament\Resources\UserResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Database\Eloquent\Model;

class AddressesRelationManager extends RelationManager
{
    protected static string $relationship = 'addresses';

    public static function getTitle(Model $ownerRecord, string $pageClass): string
    {
        return __('Addresses');
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->label(__('Address Name'))
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('address_line_1')
                    ->label(__('Address Line 1'))
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('address_line_2')
                    ->label(__('Address Line 2'))
                    ->nullable()
                    ->maxLength(255),
                Forms\Components\TextInput::make('city')
                    ->label(__('City'))
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('state')
                    ->label(__('State'))
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('zip_code')
                    ->label(__('Zip Code'))
                    ->nullable()
                    ->maxLength(255),
                Forms\Components\TextInput::make('latitude')
                    ->label(__('Latitude'))
                    ->numeric()
                    ->nullable(),
                Forms\Components\TextInput::make('longitude')
                    ->label(__('Longitude'))
                    ->numeric()
                    ->nullable(),
                Toggle::make('is_default')
                    ->label(__('Set as Default'))
                    ->inline(false)
                    ->afterStateUpdated(function ($state, $record) {
                        // Ensure $record and $record->user are not null before proceeding
                        if ($state && $record && $record->user) {
                            $record->user->addresses()->where('id', '!=', $record->id)->update(['is_default' => false]);
                        }
                    })
                    ->dehydrated(false), // Prevent is_default from being dehydrated by default
            ])->columns(2);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('name')
            ->columns([
                TextColumn::make('name')
                    ->label(__('Address Name'))
                    ->searchable(),
                TextColumn::make('address_line_1')
                    ->label(__('Address Line 1'))
                    ->searchable(),
                TextColumn::make('city')
                    ->label(__('City'))
                    ->searchable(),
                TextColumn::make('state')
                    ->label(__('State'))
                    ->searchable(),
                Tables\Columns\IconColumn::make('is_default')
                    ->label(__('Default'))
                    ->boolean(),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                // Tables\Actions\CreateAction::make()
                //     ->label(__('Create')),
            ])
            ->actions([
                // Tables\Actions\EditAction::make()
                //     ->label(__('Edit')),
                // Tables\Actions\DeleteAction::make()
                //     ->label(__('Delete')),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make()
                        ->label(__('Delete selected')),
                ])
                    ->label(__('Actions')),
            ]);
    }
}
