<?php

namespace App\Filament\Resources\BookingResource\RelationManagers;

use App\Filament\Resources\ServiceProviderResource;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class BookingItemsRelationManager extends RelationManager
{
    protected static string $relationship = 'items';

    public static function getTitle(Model $ownerRecord, string $pageClass): string
    {
        return __('items');
    }
    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('product.name_en')
                    ->label(__('Product Name'))
                    ->required()
                    ->maxLength(255),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('product.name_' . app()->getLocale())
            ->columns([
                Tables\Columns\TextColumn::make('id')->label(__('ID')),
                Tables\Columns\TextColumn::make('product.name_' . app()->getLocale())->label(__('Product Name')),
                Tables\Columns\TextColumn::make('price')->label(__('Price'))->money('SAR'),
                Tables\Columns\TextColumn::make('net_price')->label(__('Net Price'))->money('SAR'),
                Tables\Columns\TextColumn::make('commission_amount')->label(__('Commission Amount'))->money('SAR'),
                Tables\Columns\TextColumn::make('service_date')->label(__('Service Date')),
                Tables\Columns\TextColumn::make('status')->label(__('Status')),
                // Provider router and link to provider edit page
                Tables\Columns\TextColumn::make('serviceProvider.name')
                    ->label(__('Service Provider'))
                    ->url(fn($record) => ServiceProviderResource::getUrl('edit', ["record" => $record->service_provider_id]))
                    ->openUrlInNewTab(),


            ])
            ->filters([
                //
            ])
            ->headerActions([
                // Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                // Tables\Actions\EditAction::make(),
                // Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    // Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }
}
