<?php

namespace App\Filament\Pages;

use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Section;
use Filament\Forms\Form;
use Filament\Pages\Dashboard as BaseDashboard;
use App\Filament\Widgets\DashboardStatsOverview;
use Filament\Pages\Dashboard\Concerns\HasFiltersForm;
use App\Filament\Widgets\BookingStatusPieChart;
use App\Filament\Widgets\BookingTrendsChart;
use App\Filament\Widgets\RecentBookingsTable;
use App\Filament\Widgets\RevenueTrendsChart;
use App\Filament\Widgets\ReviewRatingBarChart;
use App\Filament\Widgets\TopCategoriesBarChart;
use App\Filament\Widgets\TopServiceProvidersBarChart;
use App\Filament\Widgets\TopUsersByBookingsTable;
use App\Filament\Widgets\UserGrowthChart;

class Dashboard extends BaseDashboard
{
    use HasFiltersForm;

    public function getWidgets(): array
    {
        return [
            DashboardStatsOverview::class,
            BookingStatusPieChart::class,
            BookingTrendsChart::class,
            RevenueTrendsChart::class,
            UserGrowthChart::class,
            ReviewRatingBarChart::class,
            TopCategoriesBarChart::class,
            TopServiceProvidersBarChart::class,
            // RecentBookingsTable::class,
            // TopUsersByBookingsTable::class,
        ];
    }

    public function filtersForm(Form $form): Form
    {
        return $form
            ->schema([
                Section::make(__('Date Range Filter'))
                    ->schema([
                        DatePicker::make('date_from')
                            ->reactive()
                            ->label(__('From Date'))
                            // ->default(now()->subDays(30))
                            ->live()
                            ->nullable()
                            ->afterStateUpdated(fn() => $this->dispatch('date-range-changed')),
                        DatePicker::make('date_until')
                            ->reactive()
                            ->label(__('To Date'))
                            // ->default(now())
                            ->live()
                            ->nullable()
                            ->afterStateUpdated(fn() => $this->dispatch('date-range-changed')),
                    ])
                    ->columns(2),
            ])
            ->statePath('filters');
    }

    public function mount(): void
    {
        // $this->form->fill([
        //     'date_from' => now()->subDays(30),
        //     'date_until' => now(),
        // ]);
    }
}
