<?php

namespace App\Enums;

enum CommercialRegisterType: string
{
    case COMMERCIAL_REGISTER = 'commercial_register';
    case FREELANCE_DOCUMENT = 'freelance_document';

    public static function getValues(): array
    {
        return array_column(self::cases(), 'value');
    }

    public static function fromValue(string $value): ?self
    {
        return self::from($value);
    }

    public function label(): string
    {
        return match ($this) {
            self::COMMERCIAL_REGISTER => __('Commercial Register'),
            self::FREELANCE_DOCUMENT => __('Freelance Document'),
        };
    }
    public static function options(): array
    {
        return array_combine(
            array_map(fn($case) => $case->value, self::cases()),
            array_map(fn($case) => $case->label(), self::cases())
        );
    }
}
